/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyVec3
implements IProperty<Vec3> {
    final DirectStorage<Vec3> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyVec3(DirectStorage<Vec3> value) {
        this.value = value;
    }

    public PropertyVec3() {
        this(DirectStorage.allocate());
    }

    @Override
    public Class<Vec3> getType() {
        return Vec3.class;
    }

    @Override
    public Vec3 set(Vec3 value) {
        Vec3 pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        Vec3 value = this.value.get();
        buf.writeBoolean(value != null);
        if (value != null) {
            buf.writeDouble(value.f_82479_);
            buf.writeDouble(value.f_82480_);
            buf.writeDouble(value.f_82481_);
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            this.value.set(new Vec3(x, y, z));
        } else {
            this.value.set(null);
        }
    }

    @Override
    public Vec3 get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

